define([
	'jQuery',
	'angular',
	'app'
], function (
	$,
	angular,
	app) {
	'use strict';
	app.service('sudService', function ($templateCache, $http, $log, mhpuser) {

		return {
			accept: function () {
				sessionStorage.staffUserDisclaimerAccepted = true;

				$http.put(mhpuser['link']['staff-user-disclaimer'], {staffUserDisclaimerAccepted: true}, {
					headers: {
						'Content-type': 'application/json'
					}
				}).catch(function (e) {
					$log.error(e);
				});
			},
			isReadyToServe: function () {
				return !(_.isEmpty(mhpuser) || _.isEmpty(mhpuser['link']) || _.isEmpty(mhpuser['link']['staff-user-disclaimer']));
			},
			getDisclaimerStatus: function () {
				return $http.get(mhpuser['link']['staff-user-disclaimer']).then(function (response) {
					var status = response.data;
					sessionStorage.staffUserDisclaimerAccepted = !_.isEmpty(status) && !!status.staffUserDisclaimerAccepted;
					return response.data;
				}).catch(function (e) {
					$log.error(e);
				});
			},
			getContent: function () {
				return $http.get(mhpuser['link']['staff-user-disclaimer-content'], {
					headers: {
						'Accept': 'application/json'
					}
				}).then(function (response) {
					return response.data;
				}).catch(function (e) {
					$log.error(e);
				});
			}
		}; // end return

	});
});